#declare interrior = true;  // Alatiedostot kyttvt tt, jos tm on mritelty, ne eivt mrittele omia kameroitaan ja valojaan.

/*
  interrior.pov
  Tss tiedostossa mritelln tornin sisosat.
*/

/*
  tower.pov
  Tss tiedostossa mritelln tornin kiviosat. Ne voivat olla ehjt tai hajonneet.
  Jos torni on hajonnut, siit puuttuu 252 tiilt, jotka joku perfektionisti varmaan 
  sijoittelisi ksi (siksi tiili on public).

  public
    tiili       - Suuri kivilohkare (kappale), joista torni on rakennettu.
    kerros      - Tornin yhden kerroksen korkeus, kerroksia on yhteens nelj.
    sisa        - Tornin sisnurkkien koordinaatit ovat (+/-sisa.u,+/-sisa.v).
    ulko        - Tornin ulkonurkkien koordinaatit ovat (+/-ulko.u,+/-ulko.v).
    kunto       - Tornin kunto boolean-arvolla. Jos torni on ehj, niin arvona true.

  Erikoiset
    no_tower    - Muuttujan mrittely jossain tiedostossa est tornin piirtmisen.
*/
/*
  Tarvittavat ulkopuoliset muuttujat jotka saadaan omista alitiedostoista

  tower.pov
    tiili       - Suuri kivilohkare (kappale), joista torni on rakennettu.
    kerros      - Tornin yhden kerroksen korkeus, kerroksia on yhteens nelj.
    sisa        - Tornin sisnurkkien koordinaatit ovat (+/-sisa.u,+/-sisa.v).
    ulko        - Tornin ulkonurkkien koordinaatit ovat (+/-ulko.u,+/-ulko.v).
    kunto       - Tornin kunto boolean-arvolla. Jos torni on ehj, niin arvona true.
*/

#ifndef (RuinedTower)
  #declare RuinedTower = true;
  #declare no_tower = true;
  #include "tower.pov"
  light_source { <10,20,-20> color rgb 1 }
  camera { location <8,3,-8> look_at <0,2,0> }
#end

#declare lauta_texture = texture {   
  pigment {
    wood
    turbulence 0.03725
    omega 0.65725
    lambda 2.425
    color_map {
      [.3 color rgb <.6,.3,.2>]
      [.6 color rgb <.6,.4,.2>]
      [.7 color rgb <.4,.3,.2>]
    }
    scale <0.05, 0.5, .05>
  }
}

// Kulmalauta (45 sateen kulmassa oleva lauta)
#local lauta = difference {
  box { <5,0.02,0.05> <-5,.23,.20> rotate -45*z translate <.25,.25,0> }
  plane { x 0 }
  plane { y 0 }
  texture { lauta_texture }
}

// Tm on perustukikehikko, jota kytetn ehjn tornin tukikehikkona sek rjhtneen tornin alakerran tukikehikkona.
#declare tukikehikko = union {

  // Ensimminen tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box     { <sisa,kerros-.25,sisa>  <-sisa,kerros,sisa-.25> texture { lauta_texture } }
  box     { <sisa,kerros-.25,sisa>  <sisa-.25,0,sisa-.25>   texture { lauta_texture } }
  box     { <-sisa,kerros-.25,sisa> <-sisa+.25,0,sisa-.25>  texture { lauta_texture } }
  object  { lauta rotate <180,180,0> translate <sisa,kerros-.25,-sisa>      }
  object  { lauta rotate <0,180,0>   translate <sisa,0,-sisa+.25>           }
  object  { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,-sisa+.25> }
  object  { lauta rotate <0,0,0>     translate <-sisa,0,-sisa>              }

  // Toinen tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box { <sisa,kerros-.25,.125>  <-sisa,kerros,-.125> texture { lauta_texture } }
  box { <sisa,kerros-.25,.125>  <sisa-.25,0,-.125>   texture { lauta_texture } }
  box { <-sisa,kerros-.25,.125> <-sisa+.25,0,-.125>  texture { lauta_texture } }
  object { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,.125> }
  object { lauta rotate <0,0,0>     translate <-sisa,0,-.125>         }
  object { lauta rotate <180,180,0> translate <sisa,kerros-.25,-.125> }
  object { lauta rotate <0,180,0>   translate <sisa,0,.125>           }

  // Kolmas tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box     { <sisa,kerros-.25,-sisa>  <-sisa,kerros,-sisa+.25> texture { lauta_texture } }
  box     { <sisa,kerros-.25,-sisa>  <sisa-.25,0,-sisa+.25>   texture { lauta_texture } }
  box     { <-sisa,kerros-.25,-sisa> <-sisa+.25,0,-sisa+.25>  texture { lauta_texture } }
  object  { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,sisa>    }
  object  { lauta rotate <0,0,0>     translate <-sisa,0,sisa-.25>         }
  object  { lauta rotate <180,180,0> translate <sisa,kerros-.25,sisa-.25> }
  object  { lauta rotate <0,180,0>   translate <sisa,0,sisa>              }
  
  // Lattialaudat
  
  #local mul = 10; // Lattialautojen mr
  #local lauta_leveys = 2*sisa / mul;

  box {<sisa- 0*lauta_leveys,0,sisa>      <sisa- 1*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 0*lauta_leveys,0,-sisa/3>   <sisa- 1*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 0*lauta_leveys,0,-sisa*2/3> <sisa- 1*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 1*lauta_leveys,0,sisa>      <sisa- 2*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 1*lauta_leveys,0,-sisa/3>   <sisa- 2*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 1*lauta_leveys,0,-sisa*2/3> <sisa- 2*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 2*lauta_leveys,0,sisa>      <sisa- 3*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 2*lauta_leveys,0,-sisa/3>   <sisa- 3*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 2*lauta_leveys,0,-sisa*2/3> <sisa- 3*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 3*lauta_leveys,0,sisa>      <sisa- 4*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 3*lauta_leveys,0,-sisa/3>   <sisa- 4*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 3*lauta_leveys,0,-sisa*2/3> <sisa- 4*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 4*lauta_leveys,0,sisa>      <sisa- 5*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 4*lauta_leveys,0,-sisa/3>   <sisa- 5*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 4*lauta_leveys,0,-sisa*2/3> <sisa- 5*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 5*lauta_leveys,0,sisa>      <sisa- 6*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 5*lauta_leveys,0,-sisa/3>   <sisa- 6*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 5*lauta_leveys,0,-sisa*2/3> <sisa- 6*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 6*lauta_leveys,0,sisa>      <sisa- 7*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 6*lauta_leveys,0,-sisa/3>   <sisa- 7*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 6*lauta_leveys,0,-sisa*2/3> <sisa- 7*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 7*lauta_leveys,0,sisa>      <sisa- 8*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 7*lauta_leveys,0,-sisa/3>   <sisa- 8*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 7*lauta_leveys,0,-sisa*2/3> <sisa- 8*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 8*lauta_leveys,0,sisa>      <sisa- 9*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 8*lauta_leveys,0,-sisa/3>   <sisa- 9*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 8*lauta_leveys,0,-sisa*2/3> <sisa- 9*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 9*lauta_leveys,0,sisa>      <sisa-10*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 9*lauta_leveys,0,-sisa/3>   <sisa-10*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 9*lauta_leveys,0,-sisa*2/3> <sisa-10*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

}

// Toinen kerros
#declare tukikehikko_1 = union {

  // Ensimminen tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box     { <sisa,kerros-.25,sisa>  <-sisa,kerros,sisa-.25> texture { lauta_texture } }
  box     { <sisa,kerros-.25,sisa>  <sisa-.25,0,sisa-.25>   texture { lauta_texture } }
  box     { <-sisa,kerros-.25,sisa> <-sisa+.25,0,sisa-.25>  texture { lauta_texture } }
  object  { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,sisa>    }
  object  { lauta rotate <0,0,0>     translate <-sisa,0,sisa-.25>         }
  object  { lauta rotate <180,180,0> translate <sisa,kerros-.25,sisa-.25> }
  object  { lauta rotate <0,180,0>   translate <sisa,0,sisa>              }

  // Toinen tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box { <sisa,kerros-.25,.125>  <-sisa,kerros,-.125> texture { lauta_texture } }
  box { <sisa,kerros-.25,.125>  <sisa-.25,0,-.125>   texture { lauta_texture } }
  box { <-sisa,kerros-.25,.125> <-sisa+.25,0,-.125>  texture { lauta_texture } }
  object { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,.125> }
  object { lauta rotate <0,0,0>     translate <-sisa,0,-.125>         }
  object { lauta rotate <180,180,0> translate <sisa,kerros-.25,-.125> }
  object { lauta rotate <0,180,0>   translate <sisa,0,.125>           }

  // Kolmas tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  difference {
    box     { <sisa,kerros-.25,-sisa>  <-sisa,kerros,-sisa+.25> texture { lauta_texture } }
    sphere { <sisa,kerros-.125,-sisa> 1 }
    texture { lauta_texture }
  }
  //box     { <sisa,kerros-.25,-sisa>  <sisa-.25,0,-sisa+.25>   texture { lauta_texture } }
  box     { <-sisa,kerros-.25,-sisa> <-sisa+.25,0,-sisa+.25>  texture { lauta_texture } }
  //object  { lauta rotate <180,180,0> translate <sisa,kerros-.25,-sisa>      }
  //object  { lauta rotate <0,180,0>   translate <sisa,0,-sisa+.25>           }
  object  { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,-sisa+.25> }
  object  { lauta rotate <0,0,0>     translate <-sisa,0,-sisa>              }

  // Lattialaudat
  
  #local mul = 10; // Lattialautojen mr
  #local lauta_leveys = 2*sisa / mul;

  box {<sisa- 0*lauta_leveys,0,sisa>      <sisa- 1*lauta_leveys,.1,sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 0*lauta_leveys,0,sisa/3>   <sisa- 1*lauta_leveys,.1,0> texture { lauta_texture } translate kerros*y }
  box {<sisa- 0*lauta_leveys,0,0> <sisa- 1*lauta_leveys,.1,-sisa>     texture { lauta_texture } rotate -45*x translate kerros*y }

  box {<sisa- 1*lauta_leveys,0,sisa>      <sisa- 2*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 1*lauta_leveys,0,-sisa/3>   <sisa- 2*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } rotate x*-10 translate kerros*y }
  box {<sisa- 1*lauta_leveys,0,-sisa*2/3> <sisa- 2*lauta_leveys,.1,-sisa>     texture { lauta_texture } rotate y*-10 translate 0.1*y }

  box {<sisa- 2*lauta_leveys,0,sisa>      <sisa- 3*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 2*lauta_leveys,0,-sisa/3>   <sisa- 3*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } rotate x*-5 translate kerros*y }
  box {<sisa- 2*lauta_leveys,0,-sisa*2/3> <sisa- 3*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 3*lauta_leveys,0,sisa>      <sisa- 4*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 3*lauta_leveys,0,-sisa/3>   <sisa- 4*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 3*lauta_leveys,0,-sisa*2/3> <sisa- 4*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 4*lauta_leveys,0,sisa>      <sisa- 5*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 4*lauta_leveys,0,-sisa/3>   <sisa- 5*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 4*lauta_leveys,0,-sisa*2/3> <sisa- 5*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 5*lauta_leveys,0,sisa>      <sisa- 6*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 5*lauta_leveys,0,-sisa/3>   <sisa- 6*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 5*lauta_leveys,0,-sisa*2/3> <sisa- 6*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 6*lauta_leveys,0,sisa>      <sisa- 7*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 6*lauta_leveys,0,-sisa/3>   <sisa- 7*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 6*lauta_leveys,0,-sisa*2/3> <sisa- 7*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 7*lauta_leveys,0,sisa>      <sisa- 8*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 7*lauta_leveys,0,-sisa/3>   <sisa- 8*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 7*lauta_leveys,0,-sisa*2/3> <sisa- 8*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 8*lauta_leveys,0,sisa>      <sisa- 9*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 8*lauta_leveys,0,-sisa/3>   <sisa- 9*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 8*lauta_leveys,0,-sisa*2/3> <sisa- 9*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 9*lauta_leveys,0,sisa>      <sisa-10*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 9*lauta_leveys,0,-sisa/3>   <sisa-10*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 9*lauta_leveys,0,-sisa*2/3> <sisa-10*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  
}

// Kolmas kerros
#declare tukikehikko_2 = union {

  // Ensimminen tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box     { <sisa,kerros-.25,sisa>  <-sisa,kerros,sisa-.25> texture { lauta_texture } }
  box     { <sisa,kerros-.25,sisa>  <sisa-.25,0,sisa-.25>   texture { lauta_texture } }
  box     { <-sisa,kerros-.25,sisa> <-sisa+.25,0,sisa-.25>  texture { lauta_texture } }
  object  { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,sisa>    }
  object  { lauta rotate <0,0,0>     translate <-sisa,0,sisa-.25>         }
  object  { lauta rotate <180,180,0> translate <sisa,kerros-.25,sisa-.25> }
  object  { lauta rotate <0,180,0>   translate <sisa,0,sisa>              }

  // Toinen tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box { <sisa,kerros-.25,.125>  <-sisa,kerros,-.125> translate (.35-kerros)*y rotate <0,-26,0>  texture { lauta_texture } }  // Romauta toinen p lattialle (posit. x)
  difference {   // Katkaise ylpuolisko pois
    box { <sisa,kerros-.25,.125>  <sisa-.25,0,-.125> }
    sphere { <sisa,kerros-.125,0> 1.2 }
    texture { lauta_texture }
  }
  box { <-sisa,kerros-.25,.125> <-sisa+.25,0,-.125>  texture { lauta_texture } }
  //object { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,.125> }
  object { lauta rotate <0,0,0>     translate <-sisa,0,-.125>         }
  //object { lauta rotate <180,180,0> translate <sisa,kerros-.25,-.125> }
  object { lauta rotate <0,180,0>   translate <sisa,0,.125>           }

  // Kolmas tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  difference {   // murra tm poikki suunnilleen puolesta vlin
    box     { <sisa,kerros-.25,-sisa>  <-sisa,kerros,-sisa+.25>  }
    sphere { <sisa,kerros-.125,-sisa+.125> 2 }
    texture { lauta_texture }
  }
  //box     { <sisa,kerros-.25,-sisa>  <sisa-.25,0,-sisa+.25>   texture { lauta_texture } }
  box     { <-sisa,kerros-.25,-sisa> <-sisa+.25,0,-sisa+.25>  texture { lauta_texture } }
  //object  { lauta rotate <180,180,0> translate <sisa,kerros-.25,-sisa>      }
  //object  { lauta rotate <0,180,0>   translate <sisa,0,-sisa+.25>           }
  object  { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,-sisa+.25> }
  object  { lauta rotate <0,0,0>     translate <-sisa,0,-sisa>              }
  
  // Lattialaudat
  
  #local mul = 10; // Lattialautojen mr
  #local lauta_leveys = 2*sisa / mul;

  box {<sisa- 0*lauta_leveys,0,sisa>      <sisa- 1*lauta_leveys,.1, 0>   texture { lauta_texture } translate -sisa*z rotate x*-50 translate sisa*z translate kerros*y }
  box {<sisa- 0*lauta_leveys,0,0>   <sisa- 1*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate <-sisa,0,sisa> rotate -10*y translate <sisa,0,-sisa> translate .1*y }
  box {<sisa- 0*lauta_leveys,0,-sisa*2/3> <sisa- 1*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate <-sisa,0,sisa> rotate <-10,-30,0> translate <.8*sisa,0,-.8*sisa> translate (-kerros+0.1)*y }

  box {<sisa- 1*lauta_leveys,0,sisa>      <sisa- 2*lauta_leveys,.1,-sisa/5>   texture { lauta_texture } translate -sisa*z rotate x*-30 translate sisa*z translate kerros*y }
  box {<sisa- 1*lauta_leveys,0,-sisa/5>   <sisa- 2*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate 0.2*y }
  box {<sisa- 1*lauta_leveys,0,-sisa*2/3> <sisa- 2*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate <-sisa,0,sisa> rotate <0,-20,0> translate <sisa,0,-sisa> translate 0.1*y }

  box {<sisa- 2*lauta_leveys,0,sisa>      <sisa- 3*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate -sisa*z rotate x*-50 translate sisa*z translate kerros*y }
  box {<sisa- 2*lauta_leveys,0,-sisa/3>   <sisa- 3*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate 0.1*y }
  box {<sisa- 2*lauta_leveys,0,-sisa*2/3> <sisa- 3*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate <-sisa,0,sisa> rotate -45*y translate <.6*sisa,0,-.6*sisa> translate 0.1*y }

  box {<sisa- 3*lauta_leveys,0,sisa>      <sisa- 4*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate -sisa*z rotate x*-40 translate sisa*z translate kerros*y }
  box {<sisa- 3*lauta_leveys,0,-sisa/3>   <sisa- 4*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate 0.2*y }
  box {<sisa- 3*lauta_leveys,0,-sisa*2/3> <sisa- 4*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate <-sisa,0,sisa> rotate -30*y translate <sisa,0,-.5*sisa> translate 0.1*y }

  box {<sisa- 4*lauta_leveys,0,sisa>      <sisa- 5*lauta_leveys,.1,-sisa/6>   texture { lauta_texture } translate -sisa*z rotate x*-40 translate sisa*z translate kerros*y }
  box {<sisa- 4*lauta_leveys,0,-sisa/6>   <sisa- 5*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate 0.15*y }
  box {<sisa- 4*lauta_leveys,0,-sisa*2/3> <sisa- 5*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate <-sisa,0,sisa> rotate <0,50,0> translate <sisa,0,-sisa> translate 0.1*y }

  box {<sisa- 5*lauta_leveys,0,sisa>      <sisa- 6*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate -sisa*z rotate x*-50 translate sisa*z translate kerros*y }
  box {<sisa- 5*lauta_leveys,0,-sisa/3>   <sisa- 6*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 5*lauta_leveys,0,-sisa*2/3> <sisa- 6*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 6*lauta_leveys,0,sisa>      <sisa- 7*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate -sisa*z rotate x*-40 translate sisa*z translate kerros*y }
  box {<sisa- 6*lauta_leveys,0,-sisa/3>   <sisa- 7*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 6*lauta_leveys,0,-sisa*2/3> <sisa- 7*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 7*lauta_leveys,0,sisa>      <sisa- 8*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate -sisa*z rotate x*-30 translate sisa*z translate kerros*y }
  box {<sisa- 7*lauta_leveys,0,-sisa/3>   <sisa- 8*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 7*lauta_leveys,0,-sisa*2/3> <sisa- 8*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 8*lauta_leveys,0,sisa>      <sisa- 9*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate -sisa*z rotate x*-20 translate sisa*z translate kerros*y }
  box {<sisa- 8*lauta_leveys,0,-sisa/3>   <sisa- 9*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 8*lauta_leveys,0,-sisa*2/3> <sisa- 9*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 9*lauta_leveys,0,sisa>      <sisa-10*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate -sisa*z rotate x*-10 translate sisa*z translate kerros*y }
  box {<sisa- 9*lauta_leveys,0,-sisa/3>   <sisa-10*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 9*lauta_leveys,0,-sisa*2/3> <sisa-10*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

}

// Neljs kerros
#declare tukikehikko_3 = union {

  // Ensimminen tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box     { <sisa,kerros-.25,sisa>  <-sisa,kerros,sisa-.25> texture { lauta_texture } }
  box     { <sisa,kerros-.25,sisa>  <sisa-.25,0,sisa-.25>   texture { lauta_texture } }
  box     { <-sisa,kerros-.25,sisa> <-sisa+.25,0,sisa-.25>  texture { lauta_texture } }
  object  { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,sisa>    }
  object  { lauta rotate <0,0,0>     translate <-sisa,0,sisa-.25>         }
  object  { lauta rotate <180,180,0> translate <sisa,kerros-.25,sisa-.25> }
  object  { lauta rotate <0,180,0>   translate <sisa,0,sisa>              }

  // Toinen tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box { <sisa,kerros-.25,.125>  <-sisa,kerros,-.125> texture { lauta_texture } }
  difference {  // Katkaise alakolmannes pois
    box { <sisa,kerros-.25,.125>  <sisa-.25,0,-.125>  }  
    sphere { <sisa-.125,0,0> .6 }
    texture { lauta_texture }
  }
  box { <-sisa,kerros-.25,.125> <-sisa+.25,0,-.125>  texture { lauta_texture } }
  object { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,.125> }
  object { lauta rotate <0,0,0>     translate <-sisa,0,-.125>         }
  object { lauta rotate <180,180,0> translate <sisa,kerros-.25,-.125> }
  //object { lauta rotate <0,180,0>   translate <sisa,0,.125>           }

  // Kolmas tukikehikko, jrjestys: ylhirsi, kaksi tukihirtt, nelj kulmahirtt
  box     { <sisa,kerros-.25,-sisa>  <-sisa,kerros,-sisa+.25> texture { lauta_texture } } 
  difference {  // Katkaise alakolmannes pois
    box     { <sisa,kerros-.25,-sisa>  <sisa-.25,0,-sisa+.25>   }
    sphere { <sisa-.125,0,-sisa+.125> .6 }
    texture { lauta_texture }
  }
  box     { <-sisa,kerros-.25,-sisa> <-sisa+.25,0,-sisa+.25>  texture { lauta_texture } }
  object  { lauta rotate <180,180,0> translate <sisa,kerros-.25,-sisa>      }
  //object  { lauta rotate <0,180,0>   translate <sisa,0,-sisa+.25>           }
  object  { lauta rotate <180,0,0>   translate <-sisa,kerros-.25,-sisa+.25> }
  object  { lauta rotate <0,0,0>     translate <-sisa,0,-sisa>              }
  
  // Lattialaudat
  
  #local mul = 10; // Lattialautojen mr
  #local lauta_leveys = 2*sisa / mul;

  box {<sisa- 0*lauta_leveys,0,sisa>      <sisa- 1*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 0*lauta_leveys,0,-sisa/3>   <sisa- 1*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 0*lauta_leveys,0,-sisa*2/3> <sisa- 1*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 1*lauta_leveys,0,sisa>      <sisa- 2*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 1*lauta_leveys,0,-sisa/3>   <sisa- 2*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 1*lauta_leveys,0,-sisa*2/3> <sisa- 2*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 2*lauta_leveys,0,sisa>      <sisa- 3*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 2*lauta_leveys,0,-sisa/3>   <sisa- 3*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 2*lauta_leveys,0,-sisa*2/3> <sisa- 3*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 3*lauta_leveys,0,sisa>      <sisa- 4*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 3*lauta_leveys,0,-sisa/3>   <sisa- 4*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 3*lauta_leveys,0,-sisa*2/3> <sisa- 4*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 4*lauta_leveys,0,sisa>      <sisa- 5*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 4*lauta_leveys,0,-sisa/3>   <sisa- 5*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 4*lauta_leveys,0,-sisa*2/3> <sisa- 5*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 5*lauta_leveys,0,sisa>      <sisa- 6*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 5*lauta_leveys,0,-sisa/3>   <sisa- 6*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 5*lauta_leveys,0,-sisa*2/3> <sisa- 6*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 6*lauta_leveys,0,sisa>      <sisa- 7*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 6*lauta_leveys,0,-sisa/3>   <sisa- 7*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 6*lauta_leveys,0,-sisa*2/3> <sisa- 7*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 7*lauta_leveys,0,sisa>      <sisa- 8*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 7*lauta_leveys,0,-sisa/3>   <sisa- 8*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 7*lauta_leveys,0,-sisa*2/3> <sisa- 8*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 8*lauta_leveys,0,sisa>      <sisa- 9*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 8*lauta_leveys,0,-sisa/3>   <sisa- 9*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 8*lauta_leveys,0,-sisa*2/3> <sisa- 9*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

  box {<sisa- 9*lauta_leveys,0,sisa>      <sisa-10*lauta_leveys,.1,-sisa/3>   texture { lauta_texture } translate kerros*y }
  box {<sisa- 9*lauta_leveys,0,-sisa/3>   <sisa-10*lauta_leveys,.1,-sisa*2/3> texture { lauta_texture } translate kerros*y }
  box {<sisa- 9*lauta_leveys,0,-sisa*2/3> <sisa-10*lauta_leveys,.1,-sisa>     texture { lauta_texture } translate kerros*y }

}

#if (kunto)
  object { tukikehikko }
  object { tukikehikko translate y*kerros }
  object { tukikehikko translate y*2*kerros }
  object { tukikehikko translate y*3*kerros }
#else
  object { tukikehikko }
  object { tukikehikko_1 translate y*kerros }
  object { tukikehikko_2 translate y*2*kerros }
  object { tukikehikko_3 translate y*3*kerros }
#end

// Tm osa kuuluu tower_details:iin, muista siirt myhemmin, on tss vain editoinnin helpottamiseksi
// Sitten heitelln hajonneita tiili ympriins muutama sata kappaletta =), jos siis tornin kunto on false

#if (!kunto)

union {
  // Pohjakerroksen tiilet
  object {tiili rotate <0,45,10> translate <1.2*ulko,-.02,-1.2*ulko> }
  object {tiili rotate <0,-15,-3> translate <1.2*ulko,0,-1.2*ulko> rotate 30*y }
  object {tiili rotate <-90,-12,20> translate <1.2*ulko,0,-1.2*ulko> rotate 40*y }
  object {tiili rotate <-90,25,2> translate <1.2*ulko,0,-1.2*ulko> rotate 13*y }
  object {tiili rotate <-90,25,7.5> translate <1*ulko,0,-1*ulko> rotate 3*y }
  object {tiili rotate <-90,-95,4> translate <1*ulko,0,-1*ulko> rotate 60*y }
  object {tiili rotate <-90,-65,5> translate <1*ulko,0,-1*ulko> rotate 23*y }
  object {tiili rotate <-90,-65,-2> translate <1.5*ulko,0,-1.5*ulko> }

  object {tiili rotate <-90,-65,0> translate <1*ulko,0,-1*ulko> rotate -13*y }
  object {tiili rotate <-90,-35,0> translate <1*ulko,0,-1.2*ulko> rotate -13*y }
  object {tiili rotate <-90,45,0> translate <1*ulko,0,-1.2*ulko> rotate -13*y }
  object {tiili rotate <-90,-45,0> translate <1*ulko-.1,.25,-1.2*ulko-.4> rotate -13*y }

  object {tiili rotate <-90,-65,0> translate <0,0,-1.5*ulko> }
  object {tiili rotate <-90,-75,0> translate <0,0,-1.3*ulko> }
  object {tiili rotate <-90,-55,0> translate <.5,0,-1.3*ulko> }

  object {tiili rotate <-90,-90,0> translate <.5,.25,-1.3*ulko> }
  object {tiili rotate <-90,25,0> translate <0,.25,-1.3*ulko> }

  object {tiili rotate <-90,25,0> translate <2,0,-1.3*ulko> }
  object {tiili rotate <0,90,0> translate <1.75,.25,-1.3*ulko> }



  object {tiili rotate <0,45,10> translate <2.2*ulko,-.02,-2.2*ulko> }
  object {tiili rotate <0,-15,-3> translate <2.2*ulko,0,-1.9*ulko> rotate 30*y }
  object {tiili rotate <-90,-12,20> translate <1.7*ulko,0,-2.2*ulko> rotate 40*y }
  object {tiili rotate <-90,25,2> translate <1.6*ulko,0,-1.8*ulko> rotate 13*y }
  object {tiili rotate <-90,25,7.5> translate <1.5*ulko,0,-2*ulko> rotate 3*y }
  object {tiili rotate <-90,-65,-2> translate <1.5*ulko,0,-1.5*ulko> }

  object {tiili rotate <-90,-65,-25> translate <1.5*ulko,0,-1.6*ulko> rotate -13*y }
  object {tiili rotate <-90,-35,45> translate <1.4*ulko,0,-1.8*ulko> rotate -13*y }
  object {tiili rotate <-90,45,15> translate <1.6*ulko,0,-1.8*ulko> rotate -13*y }


  // Kakkoskerroksen tiilet
  object {tiili translate <0,(kerros+.1),0> }
  object {tiili rotate <0,0,10> translate <0,(kerros+.1),-sisa/2> }
  object {tiili rotate <0,0,0> translate <1,(kerros+.2),-sisa*2/3> }
  object {tiili rotate <0,30,0> translate <-1,(kerros+.1),-sisa*2/3> }
  object {tiili rotate <-90,-30,0> translate <0,(kerros+.1),-sisa*2/3> }
  object {tiili rotate <-90,-30,0> translate <-.5,(kerros+.1),-sisa*2/3+1> }
  object {tiili rotate <-90,45,0> translate <-1,(kerros+.1),-sisa*1/3> }
  object {tiili rotate <-90,45,0> translate <-.7,(kerros+.1),-sisa*1/3> }
  object {tiili rotate <0,-10,-10>translate <sisa/2,(kerros+.2),-sisa/2> }
  object {tiili rotate <-90,10,-10>translate <sisa*4/6,(kerros+.2),-sisa*5/6> }
  object {tiili rotate <-90,64,0>translate <sisa*2/6,(kerros+.1),-sisa*5/6> }
  object {tiili rotate <-90,64,0>translate <sisa*3.5/6,(kerros+.1),-sisa*5/6> }
  object {tiili rotate <-90,45,0> translate <-1,(kerros+.4),-sisa*1/3> }
  object {tiili rotate <0,45,-10>translate <sisa/2,(kerros+.5),-sisa/2> }

  // Kolmoskerroksen tiilet

  texture { wall_colour }
  texture {       // Kristetn irtotiilikin vhn
    pigment { 
      granite       
      color_map {
          [0 color rgbt <0,0,0,0>]
          [0.8 color rgbt <0,0,0,1>]
          [1 color rgbt <0,0,0,1>]
      }
      scale 2
    }
  }
}
#end